/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.InsightsSettingsCommentFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InsightsSettingsComment
extends Resource {
    private static final long serialVersionUID = 241533672645071L;
    private final String accountSid;
    private final Map<String, Object> comments;
    private final URI url;

    public static InsightsSettingsCommentFetcher fetcher() {
        return new InsightsSettingsCommentFetcher();
    }

    public static InsightsSettingsComment fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsSettingsComment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InsightsSettingsComment fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsSettingsComment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InsightsSettingsComment(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="comments") Map<String, Object> comments, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.comments = comments;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Map<String, Object> getComments() {
        return this.comments;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightsSettingsComment other = (InsightsSettingsComment)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.comments, other.comments) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.comments, this.url);
    }

    public String toString() {
        return "InsightsSettingsComment(accountSid=" + this.getAccountSid() + ", comments=" + this.getComments() + ", url=" + this.getUrl() + ")";
    }
}

