/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.InsightsSettingsAnswerSetsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InsightsSettingsAnswerSets
extends Resource {
    private static final long serialVersionUID = 252326702169213L;
    private final String accountSid;
    private final Map<String, Object> answerSets;
    private final Map<String, Object> answerSetCategories;
    private final Map<String, Object> notApplicable;
    private final URI url;

    public static InsightsSettingsAnswerSetsFetcher fetcher() {
        return new InsightsSettingsAnswerSetsFetcher();
    }

    public static InsightsSettingsAnswerSets fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsSettingsAnswerSets.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InsightsSettingsAnswerSets fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsSettingsAnswerSets.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InsightsSettingsAnswerSets(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="answer_sets") Map<String, Object> answerSets, @JsonProperty(value="answer_set_categories") Map<String, Object> answerSetCategories, @JsonProperty(value="not_applicable") Map<String, Object> notApplicable, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.answerSets = answerSets;
        this.answerSetCategories = answerSetCategories;
        this.notApplicable = notApplicable;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Map<String, Object> getAnswerSets() {
        return this.answerSets;
    }

    public final Map<String, Object> getAnswerSetCategories() {
        return this.answerSetCategories;
    }

    public final Map<String, Object> getNotApplicable() {
        return this.notApplicable;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightsSettingsAnswerSets other = (InsightsSettingsAnswerSets)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.answerSets, other.answerSets) && Objects.equals(this.answerSetCategories, other.answerSetCategories) && Objects.equals(this.notApplicable, other.notApplicable) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.answerSets, this.answerSetCategories, this.notApplicable, this.url);
    }

    public String toString() {
        return "InsightsSettingsAnswerSets(accountSid=" + this.getAccountSid() + ", answerSets=" + this.getAnswerSets() + ", answerSetCategories=" + this.getAnswerSetCategories() + ", notApplicable=" + this.getNotApplicable() + ", url=" + this.getUrl() + ")";
    }
}

