/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.InsightsSessionCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InsightsSession
extends Resource {
    private static final long serialVersionUID = 184746612300929L;
    private final String workspaceId;
    private final String sessionExpiry;
    private final String sessionId;
    private final String baseUrl;
    private final URI url;

    public static InsightsSessionCreator creator() {
        return new InsightsSessionCreator();
    }

    public static InsightsSession fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsSession.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InsightsSession fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsSession.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InsightsSession(@JsonProperty(value="workspace_id") String workspaceId, @JsonProperty(value="session_expiry") String sessionExpiry, @JsonProperty(value="session_id") String sessionId, @JsonProperty(value="base_url") String baseUrl, @JsonProperty(value="url") URI url) {
        this.workspaceId = workspaceId;
        this.sessionExpiry = sessionExpiry;
        this.sessionId = sessionId;
        this.baseUrl = baseUrl;
        this.url = url;
    }

    public final String getWorkspaceId() {
        return this.workspaceId;
    }

    public final String getSessionExpiry() {
        return this.sessionExpiry;
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    public final String getBaseUrl() {
        return this.baseUrl;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightsSession other = (InsightsSession)o;
        return Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.sessionExpiry, other.sessionExpiry) && Objects.equals(this.sessionId, other.sessionId) && Objects.equals(this.baseUrl, other.baseUrl) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.workspaceId, this.sessionExpiry, this.sessionId, this.baseUrl, this.url);
    }

    public String toString() {
        return "InsightsSession(workspaceId=" + this.getWorkspaceId() + ", sessionExpiry=" + this.getSessionExpiry() + ", sessionId=" + this.getSessionId() + ", baseUrl=" + this.getBaseUrl() + ", url=" + this.getUrl() + ")";
    }
}

