/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.InsightsSegmentsReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InsightsSegments
extends Resource {
    private static final long serialVersionUID = 85034429282364L;
    private final String segmentId;
    private final String externalId;
    private final String queue;
    private final String externalContact;
    private final String externalSegmentLinkId;
    private final String date;
    private final String accountId;
    private final String externalSegmentLink;
    private final String agentId;
    private final String agentPhone;
    private final String agentName;
    private final String agentTeamName;
    private final String agentTeamNameInHierarchy;
    private final String agentLink;
    private final String customerPhone;
    private final String customerName;
    private final String customerLink;
    private final String segmentRecordingOffset;
    private final Map<String, Object> media;
    private final Map<String, Object> assessmentType;
    private final Map<String, Object> assessmentPercentage;
    private final URI url;

    public static InsightsSegmentsReader reader() {
        return new InsightsSegmentsReader();
    }

    public static InsightsSegments fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsSegments.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InsightsSegments fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsSegments.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InsightsSegments(@JsonProperty(value="segment_id") String segmentId, @JsonProperty(value="external_id") String externalId, @JsonProperty(value="queue") String queue, @JsonProperty(value="external_contact") String externalContact, @JsonProperty(value="external_segment_link_id") String externalSegmentLinkId, @JsonProperty(value="date") String date, @JsonProperty(value="account_id") String accountId, @JsonProperty(value="external_segment_link") String externalSegmentLink, @JsonProperty(value="agent_id") String agentId, @JsonProperty(value="agent_phone") String agentPhone, @JsonProperty(value="agent_name") String agentName, @JsonProperty(value="agent_team_name") String agentTeamName, @JsonProperty(value="agent_team_name_in_hierarchy") String agentTeamNameInHierarchy, @JsonProperty(value="agent_link") String agentLink, @JsonProperty(value="customer_phone") String customerPhone, @JsonProperty(value="customer_name") String customerName, @JsonProperty(value="customer_link") String customerLink, @JsonProperty(value="segment_recording_offset") String segmentRecordingOffset, @JsonProperty(value="media") Map<String, Object> media, @JsonProperty(value="assessment_type") Map<String, Object> assessmentType, @JsonProperty(value="assessment_percentage") Map<String, Object> assessmentPercentage, @JsonProperty(value="url") URI url) {
        this.segmentId = segmentId;
        this.externalId = externalId;
        this.queue = queue;
        this.externalContact = externalContact;
        this.externalSegmentLinkId = externalSegmentLinkId;
        this.date = date;
        this.accountId = accountId;
        this.externalSegmentLink = externalSegmentLink;
        this.agentId = agentId;
        this.agentPhone = agentPhone;
        this.agentName = agentName;
        this.agentTeamName = agentTeamName;
        this.agentTeamNameInHierarchy = agentTeamNameInHierarchy;
        this.agentLink = agentLink;
        this.customerPhone = customerPhone;
        this.customerName = customerName;
        this.customerLink = customerLink;
        this.segmentRecordingOffset = segmentRecordingOffset;
        this.media = media;
        this.assessmentType = assessmentType;
        this.assessmentPercentage = assessmentPercentage;
        this.url = url;
    }

    public final String getSegmentId() {
        return this.segmentId;
    }

    public final String getExternalId() {
        return this.externalId;
    }

    public final String getQueue() {
        return this.queue;
    }

    public final String getExternalContact() {
        return this.externalContact;
    }

    public final String getExternalSegmentLinkId() {
        return this.externalSegmentLinkId;
    }

    public final String getDate() {
        return this.date;
    }

    public final String getAccountId() {
        return this.accountId;
    }

    public final String getExternalSegmentLink() {
        return this.externalSegmentLink;
    }

    public final String getAgentId() {
        return this.agentId;
    }

    public final String getAgentPhone() {
        return this.agentPhone;
    }

    public final String getAgentName() {
        return this.agentName;
    }

    public final String getAgentTeamName() {
        return this.agentTeamName;
    }

    public final String getAgentTeamNameInHierarchy() {
        return this.agentTeamNameInHierarchy;
    }

    public final String getAgentLink() {
        return this.agentLink;
    }

    public final String getCustomerPhone() {
        return this.customerPhone;
    }

    public final String getCustomerName() {
        return this.customerName;
    }

    public final String getCustomerLink() {
        return this.customerLink;
    }

    public final String getSegmentRecordingOffset() {
        return this.segmentRecordingOffset;
    }

    public final Map<String, Object> getMedia() {
        return this.media;
    }

    public final Map<String, Object> getAssessmentType() {
        return this.assessmentType;
    }

    public final Map<String, Object> getAssessmentPercentage() {
        return this.assessmentPercentage;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightsSegments other = (InsightsSegments)o;
        return Objects.equals(this.segmentId, other.segmentId) && Objects.equals(this.externalId, other.externalId) && Objects.equals(this.queue, other.queue) && Objects.equals(this.externalContact, other.externalContact) && Objects.equals(this.externalSegmentLinkId, other.externalSegmentLinkId) && Objects.equals(this.date, other.date) && Objects.equals(this.accountId, other.accountId) && Objects.equals(this.externalSegmentLink, other.externalSegmentLink) && Objects.equals(this.agentId, other.agentId) && Objects.equals(this.agentPhone, other.agentPhone) && Objects.equals(this.agentName, other.agentName) && Objects.equals(this.agentTeamName, other.agentTeamName) && Objects.equals(this.agentTeamNameInHierarchy, other.agentTeamNameInHierarchy) && Objects.equals(this.agentLink, other.agentLink) && Objects.equals(this.customerPhone, other.customerPhone) && Objects.equals(this.customerName, other.customerName) && Objects.equals(this.customerLink, other.customerLink) && Objects.equals(this.segmentRecordingOffset, other.segmentRecordingOffset) && Objects.equals(this.media, other.media) && Objects.equals(this.assessmentType, other.assessmentType) && Objects.equals(this.assessmentPercentage, other.assessmentPercentage) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.segmentId, this.externalId, this.queue, this.externalContact, this.externalSegmentLinkId, this.date, this.accountId, this.externalSegmentLink, this.agentId, this.agentPhone, this.agentName, this.agentTeamName, this.agentTeamNameInHierarchy, this.agentLink, this.customerPhone, this.customerName, this.customerLink, this.segmentRecordingOffset, this.media, this.assessmentType, this.assessmentPercentage, this.url);
    }

    public String toString() {
        return "InsightsSegments(segmentId=" + this.getSegmentId() + ", externalId=" + this.getExternalId() + ", queue=" + this.getQueue() + ", externalContact=" + this.getExternalContact() + ", externalSegmentLinkId=" + this.getExternalSegmentLinkId() + ", date=" + this.getDate() + ", accountId=" + this.getAccountId() + ", externalSegmentLink=" + this.getExternalSegmentLink() + ", agentId=" + this.getAgentId() + ", agentPhone=" + this.getAgentPhone() + ", agentName=" + this.getAgentName() + ", agentTeamName=" + this.getAgentTeamName() + ", agentTeamNameInHierarchy=" + this.getAgentTeamNameInHierarchy() + ", agentLink=" + this.getAgentLink() + ", customerPhone=" + this.getCustomerPhone() + ", customerName=" + this.getCustomerName() + ", customerLink=" + this.getCustomerLink() + ", segmentRecordingOffset=" + this.getSegmentRecordingOffset() + ", media=" + this.getMedia() + ", assessmentType=" + this.getAssessmentType() + ", assessmentPercentage=" + this.getAssessmentPercentage() + ", url=" + this.getUrl() + ")";
    }
}

