/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesQuestion;

public class InsightsQuestionnairesQuestionUpdater
extends Updater<InsightsQuestionnairesQuestion> {
    private String pathQuestionSid;
    private Boolean allowNa;
    private String authorization;
    private String categorySid;
    private String question;
    private String description;
    private String answerSetId;

    public InsightsQuestionnairesQuestionUpdater(String pathQuestionSid, Boolean allowNa) {
        this.pathQuestionSid = pathQuestionSid;
        this.allowNa = allowNa;
    }

    public InsightsQuestionnairesQuestionUpdater setAllowNa(Boolean allowNa) {
        this.allowNa = allowNa;
        return this;
    }

    public InsightsQuestionnairesQuestionUpdater setAuthorization(String authorization) {
        this.authorization = authorization;
        return this;
    }

    public InsightsQuestionnairesQuestionUpdater setCategorySid(String categorySid) {
        this.categorySid = categorySid;
        return this;
    }

    public InsightsQuestionnairesQuestionUpdater setQuestion(String question) {
        this.question = question;
        return this;
    }

    public InsightsQuestionnairesQuestionUpdater setDescription(String description) {
        this.description = description;
        return this;
    }

    public InsightsQuestionnairesQuestionUpdater setAnswerSetId(String answerSetId) {
        this.answerSetId = answerSetId;
        return this;
    }

    @Override
    public InsightsQuestionnairesQuestion update(TwilioRestClient client) {
        String path = "/v1/Insights/QualityManagement/Questions/{QuestionSid}";
        path = path.replace("{QuestionSid}", this.pathQuestionSid.toString());
        path = path.replace("{AllowNa}", this.allowNa.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InsightsQuestionnairesQuestion update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return InsightsQuestionnairesQuestion.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.allowNa != null) {
            request.addPostParam("AllowNa", this.allowNa.toString());
        }
        if (this.categorySid != null) {
            request.addPostParam("CategorySid", this.categorySid);
        }
        if (this.question != null) {
            request.addPostParam("Question", this.question);
        }
        if (this.description != null) {
            request.addPostParam("Description", this.description);
        }
        if (this.answerSetId != null) {
            request.addPostParam("AnswerSetId", this.answerSetId);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.authorization != null) {
            request.addHeaderParam("Authorization", this.authorization);
        }
    }
}

