/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesCategory;

public class InsightsQuestionnairesCategoryDeleter
extends Deleter<InsightsQuestionnairesCategory> {
    private String pathCategorySid;
    private String authorization;

    public InsightsQuestionnairesCategoryDeleter(String pathCategorySid) {
        this.pathCategorySid = pathCategorySid;
    }

    public InsightsQuestionnairesCategoryDeleter setAuthorization(String authorization) {
        this.authorization = authorization;
        return this;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        String path = "/v1/Insights/QualityManagement/Categories/{CategorySid}";
        path = path.replace("{CategorySid}", this.pathCategorySid.toString());
        Request request = new Request(HttpMethod.DELETE, Domains.FLEXAPI.toString(), path);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InsightsQuestionnairesCategory delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return response.getStatusCode() == 204;
    }

    private void addHeaderParams(Request request) {
        if (this.authorization != null) {
            request.addHeaderParam("Authorization", this.authorization);
        }
    }
}

