/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesCategoryCreator;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesCategoryDeleter;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesCategoryReader;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesCategoryUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InsightsQuestionnairesCategory
extends Resource {
    private static final long serialVersionUID = 80122837059940L;
    private final String accountSid;
    private final String categorySid;
    private final String name;
    private final URI url;

    public static InsightsQuestionnairesCategoryCreator creator(String name) {
        return new InsightsQuestionnairesCategoryCreator(name);
    }

    public static InsightsQuestionnairesCategoryDeleter deleter(String pathCategorySid) {
        return new InsightsQuestionnairesCategoryDeleter(pathCategorySid);
    }

    public static InsightsQuestionnairesCategoryReader reader() {
        return new InsightsQuestionnairesCategoryReader();
    }

    public static InsightsQuestionnairesCategoryUpdater updater(String pathCategorySid, String name) {
        return new InsightsQuestionnairesCategoryUpdater(pathCategorySid, name);
    }

    public static InsightsQuestionnairesCategory fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsQuestionnairesCategory.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InsightsQuestionnairesCategory fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsQuestionnairesCategory.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InsightsQuestionnairesCategory(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="category_sid") String categorySid, @JsonProperty(value="name") String name, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.categorySid = categorySid;
        this.name = name;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCategorySid() {
        return this.categorySid;
    }

    public final String getName() {
        return this.name;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightsQuestionnairesCategory other = (InsightsQuestionnairesCategory)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.categorySid, other.categorySid) && Objects.equals(this.name, other.name) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.categorySid, this.name, this.url);
    }

    public String toString() {
        return "InsightsQuestionnairesCategory(accountSid=" + this.getAccountSid() + ", categorySid=" + this.getCategorySid() + ", name=" + this.getName() + ", url=" + this.getUrl() + ")";
    }
}

