/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.Configuration;

public class ConfigurationUpdater
extends Updater<Configuration> {
    private Object body;

    public ConfigurationUpdater setBody(Object body) {
        this.body = body;
        return this;
    }

    @Override
    public Configuration update(TwilioRestClient client) {
        String path = "/v1/Configuration";
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Configuration update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Configuration.fromJson(response.getStream(), client.getObjectMapper());
    }
}

