/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.ConfigurationFetcher;
import com.twilio.rest.flexapi.v1.ConfigurationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Configuration
extends Resource {
    private static final long serialVersionUID = 32578567436971L;
    private final String accountSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final Map<String, Object> attributes;
    private final Status status;
    private final String taskrouterWorkspaceSid;
    private final String taskrouterTargetWorkflowSid;
    private final String taskrouterTargetTaskqueueSid;
    private final List<Map<String, Object>> taskrouterTaskqueues;
    private final List<Map<String, Object>> taskrouterSkills;
    private final Map<String, Object> taskrouterWorkerChannels;
    private final Map<String, Object> taskrouterWorkerAttributes;
    private final String taskrouterOfflineActivitySid;
    private final URI runtimeDomain;
    private final String messagingServiceInstanceSid;
    private final String chatServiceInstanceSid;
    private final String flexServiceInstanceSid;
    private final String flexInstanceSid;
    private final String uiLanguage;
    private final Map<String, Object> uiAttributes;
    private final Map<String, Object> uiDependencies;
    private final String uiVersion;
    private final String serviceVersion;
    private final Boolean callRecordingEnabled;
    private final URI callRecordingWebhookUrl;
    private final Boolean crmEnabled;
    private final String crmType;
    private final URI crmCallbackUrl;
    private final URI crmFallbackUrl;
    private final Map<String, Object> crmAttributes;
    private final Map<String, Object> publicAttributes;
    private final Boolean pluginServiceEnabled;
    private final Map<String, Object> pluginServiceAttributes;
    private final List<Map<String, Object>> integrations;
    private final Map<String, Object> outboundCallFlows;
    private final List<String> serverlessServiceSids;
    private final Map<String, Object> queueStatsConfiguration;
    private final Map<String, Object> notifications;
    private final Map<String, Object> markdown;
    private final URI url;
    private final Map<String, Object> flexInsightsHr;
    private final Boolean flexInsightsDrilldown;
    private final URI flexUrl;
    private final List<Map<String, Object>> channelConfigs;
    private final Map<String, Object> debuggerIntegration;
    private final Map<String, Object> flexUiStatusReport;
    private final Map<String, Object> agentConvEndMethods;
    private final Map<String, Object> citrixVoiceVdi;
    private final Map<String, Object> offlineConfig;

    public static ConfigurationFetcher fetcher() {
        return new ConfigurationFetcher();
    }

    public static ConfigurationUpdater updater() {
        return new ConfigurationUpdater();
    }

    public static Configuration fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Configuration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Configuration fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Configuration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static String toJson(Object object, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Configuration(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="attributes") Map<String, Object> attributes, @JsonProperty(value="status") Status status, @JsonProperty(value="taskrouter_workspace_sid") String taskrouterWorkspaceSid, @JsonProperty(value="taskrouter_target_workflow_sid") String taskrouterTargetWorkflowSid, @JsonProperty(value="taskrouter_target_taskqueue_sid") String taskrouterTargetTaskqueueSid, @JsonProperty(value="taskrouter_taskqueues") List<Map<String, Object>> taskrouterTaskqueues, @JsonProperty(value="taskrouter_skills") List<Map<String, Object>> taskrouterSkills, @JsonProperty(value="taskrouter_worker_channels") Map<String, Object> taskrouterWorkerChannels, @JsonProperty(value="taskrouter_worker_attributes") Map<String, Object> taskrouterWorkerAttributes, @JsonProperty(value="taskrouter_offline_activity_sid") String taskrouterOfflineActivitySid, @JsonProperty(value="runtime_domain") URI runtimeDomain, @JsonProperty(value="messaging_service_instance_sid") String messagingServiceInstanceSid, @JsonProperty(value="chat_service_instance_sid") String chatServiceInstanceSid, @JsonProperty(value="flex_service_instance_sid") String flexServiceInstanceSid, @JsonProperty(value="flex_instance_sid") String flexInstanceSid, @JsonProperty(value="ui_language") String uiLanguage, @JsonProperty(value="ui_attributes") Map<String, Object> uiAttributes, @JsonProperty(value="ui_dependencies") Map<String, Object> uiDependencies, @JsonProperty(value="ui_version") String uiVersion, @JsonProperty(value="service_version") String serviceVersion, @JsonProperty(value="call_recording_enabled") Boolean callRecordingEnabled, @JsonProperty(value="call_recording_webhook_url") URI callRecordingWebhookUrl, @JsonProperty(value="crm_enabled") Boolean crmEnabled, @JsonProperty(value="crm_type") String crmType, @JsonProperty(value="crm_callback_url") URI crmCallbackUrl, @JsonProperty(value="crm_fallback_url") URI crmFallbackUrl, @JsonProperty(value="crm_attributes") Map<String, Object> crmAttributes, @JsonProperty(value="public_attributes") Map<String, Object> publicAttributes, @JsonProperty(value="plugin_service_enabled") Boolean pluginServiceEnabled, @JsonProperty(value="plugin_service_attributes") Map<String, Object> pluginServiceAttributes, @JsonProperty(value="integrations") List<Map<String, Object>> integrations, @JsonProperty(value="outbound_call_flows") Map<String, Object> outboundCallFlows, @JsonProperty(value="serverless_service_sids") List<String> serverlessServiceSids, @JsonProperty(value="queue_stats_configuration") Map<String, Object> queueStatsConfiguration, @JsonProperty(value="notifications") Map<String, Object> notifications, @JsonProperty(value="markdown") Map<String, Object> markdown, @JsonProperty(value="url") URI url, @JsonProperty(value="flex_insights_hr") Map<String, Object> flexInsightsHr, @JsonProperty(value="flex_insights_drilldown") Boolean flexInsightsDrilldown, @JsonProperty(value="flex_url") URI flexUrl, @JsonProperty(value="channel_configs") List<Map<String, Object>> channelConfigs, @JsonProperty(value="debugger_integration") Map<String, Object> debuggerIntegration, @JsonProperty(value="flex_ui_status_report") Map<String, Object> flexUiStatusReport, @JsonProperty(value="agent_conv_end_methods") Map<String, Object> agentConvEndMethods, @JsonProperty(value="citrix_voice_vdi") Map<String, Object> citrixVoiceVdi, @JsonProperty(value="offline_config") Map<String, Object> offlineConfig) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.attributes = attributes;
        this.status = status;
        this.taskrouterWorkspaceSid = taskrouterWorkspaceSid;
        this.taskrouterTargetWorkflowSid = taskrouterTargetWorkflowSid;
        this.taskrouterTargetTaskqueueSid = taskrouterTargetTaskqueueSid;
        this.taskrouterTaskqueues = taskrouterTaskqueues;
        this.taskrouterSkills = taskrouterSkills;
        this.taskrouterWorkerChannels = taskrouterWorkerChannels;
        this.taskrouterWorkerAttributes = taskrouterWorkerAttributes;
        this.taskrouterOfflineActivitySid = taskrouterOfflineActivitySid;
        this.runtimeDomain = runtimeDomain;
        this.messagingServiceInstanceSid = messagingServiceInstanceSid;
        this.chatServiceInstanceSid = chatServiceInstanceSid;
        this.flexServiceInstanceSid = flexServiceInstanceSid;
        this.flexInstanceSid = flexInstanceSid;
        this.uiLanguage = uiLanguage;
        this.uiAttributes = uiAttributes;
        this.uiDependencies = uiDependencies;
        this.uiVersion = uiVersion;
        this.serviceVersion = serviceVersion;
        this.callRecordingEnabled = callRecordingEnabled;
        this.callRecordingWebhookUrl = callRecordingWebhookUrl;
        this.crmEnabled = crmEnabled;
        this.crmType = crmType;
        this.crmCallbackUrl = crmCallbackUrl;
        this.crmFallbackUrl = crmFallbackUrl;
        this.crmAttributes = crmAttributes;
        this.publicAttributes = publicAttributes;
        this.pluginServiceEnabled = pluginServiceEnabled;
        this.pluginServiceAttributes = pluginServiceAttributes;
        this.integrations = integrations;
        this.outboundCallFlows = outboundCallFlows;
        this.serverlessServiceSids = serverlessServiceSids;
        this.queueStatsConfiguration = queueStatsConfiguration;
        this.notifications = notifications;
        this.markdown = markdown;
        this.url = url;
        this.flexInsightsHr = flexInsightsHr;
        this.flexInsightsDrilldown = flexInsightsDrilldown;
        this.flexUrl = flexUrl;
        this.channelConfigs = channelConfigs;
        this.debuggerIntegration = debuggerIntegration;
        this.flexUiStatusReport = flexUiStatusReport;
        this.agentConvEndMethods = agentConvEndMethods;
        this.citrixVoiceVdi = citrixVoiceVdi;
        this.offlineConfig = offlineConfig;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getTaskrouterWorkspaceSid() {
        return this.taskrouterWorkspaceSid;
    }

    public final String getTaskrouterTargetWorkflowSid() {
        return this.taskrouterTargetWorkflowSid;
    }

    public final String getTaskrouterTargetTaskqueueSid() {
        return this.taskrouterTargetTaskqueueSid;
    }

    public final List<Map<String, Object>> getTaskrouterTaskqueues() {
        return this.taskrouterTaskqueues;
    }

    public final List<Map<String, Object>> getTaskrouterSkills() {
        return this.taskrouterSkills;
    }

    public final Map<String, Object> getTaskrouterWorkerChannels() {
        return this.taskrouterWorkerChannels;
    }

    public final Map<String, Object> getTaskrouterWorkerAttributes() {
        return this.taskrouterWorkerAttributes;
    }

    public final String getTaskrouterOfflineActivitySid() {
        return this.taskrouterOfflineActivitySid;
    }

    public final URI getRuntimeDomain() {
        return this.runtimeDomain;
    }

    public final String getMessagingServiceInstanceSid() {
        return this.messagingServiceInstanceSid;
    }

    public final String getChatServiceInstanceSid() {
        return this.chatServiceInstanceSid;
    }

    public final String getFlexServiceInstanceSid() {
        return this.flexServiceInstanceSid;
    }

    public final String getFlexInstanceSid() {
        return this.flexInstanceSid;
    }

    public final String getUiLanguage() {
        return this.uiLanguage;
    }

    public final Map<String, Object> getUiAttributes() {
        return this.uiAttributes;
    }

    public final Map<String, Object> getUiDependencies() {
        return this.uiDependencies;
    }

    public final String getUiVersion() {
        return this.uiVersion;
    }

    public final String getServiceVersion() {
        return this.serviceVersion;
    }

    public final Boolean getCallRecordingEnabled() {
        return this.callRecordingEnabled;
    }

    public final URI getCallRecordingWebhookUrl() {
        return this.callRecordingWebhookUrl;
    }

    public final Boolean getCrmEnabled() {
        return this.crmEnabled;
    }

    public final String getCrmType() {
        return this.crmType;
    }

    public final URI getCrmCallbackUrl() {
        return this.crmCallbackUrl;
    }

    public final URI getCrmFallbackUrl() {
        return this.crmFallbackUrl;
    }

    public final Map<String, Object> getCrmAttributes() {
        return this.crmAttributes;
    }

    public final Map<String, Object> getPublicAttributes() {
        return this.publicAttributes;
    }

    public final Boolean getPluginServiceEnabled() {
        return this.pluginServiceEnabled;
    }

    public final Map<String, Object> getPluginServiceAttributes() {
        return this.pluginServiceAttributes;
    }

    public final List<Map<String, Object>> getIntegrations() {
        return this.integrations;
    }

    public final Map<String, Object> getOutboundCallFlows() {
        return this.outboundCallFlows;
    }

    public final List<String> getServerlessServiceSids() {
        return this.serverlessServiceSids;
    }

    public final Map<String, Object> getQueueStatsConfiguration() {
        return this.queueStatsConfiguration;
    }

    public final Map<String, Object> getNotifications() {
        return this.notifications;
    }

    public final Map<String, Object> getMarkdown() {
        return this.markdown;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, Object> getFlexInsightsHr() {
        return this.flexInsightsHr;
    }

    public final Boolean getFlexInsightsDrilldown() {
        return this.flexInsightsDrilldown;
    }

    public final URI getFlexUrl() {
        return this.flexUrl;
    }

    public final List<Map<String, Object>> getChannelConfigs() {
        return this.channelConfigs;
    }

    public final Map<String, Object> getDebuggerIntegration() {
        return this.debuggerIntegration;
    }

    public final Map<String, Object> getFlexUiStatusReport() {
        return this.flexUiStatusReport;
    }

    public final Map<String, Object> getAgentConvEndMethods() {
        return this.agentConvEndMethods;
    }

    public final Map<String, Object> getCitrixVoiceVdi() {
        return this.citrixVoiceVdi;
    }

    public final Map<String, Object> getOfflineConfig() {
        return this.offlineConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration other = (Configuration)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.attributes, other.attributes) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.taskrouterWorkspaceSid, other.taskrouterWorkspaceSid) && Objects.equals(this.taskrouterTargetWorkflowSid, other.taskrouterTargetWorkflowSid) && Objects.equals(this.taskrouterTargetTaskqueueSid, other.taskrouterTargetTaskqueueSid) && Objects.equals(this.taskrouterTaskqueues, other.taskrouterTaskqueues) && Objects.equals(this.taskrouterSkills, other.taskrouterSkills) && Objects.equals(this.taskrouterWorkerChannels, other.taskrouterWorkerChannels) && Objects.equals(this.taskrouterWorkerAttributes, other.taskrouterWorkerAttributes) && Objects.equals(this.taskrouterOfflineActivitySid, other.taskrouterOfflineActivitySid) && Objects.equals(this.runtimeDomain, other.runtimeDomain) && Objects.equals(this.messagingServiceInstanceSid, other.messagingServiceInstanceSid) && Objects.equals(this.chatServiceInstanceSid, other.chatServiceInstanceSid) && Objects.equals(this.flexServiceInstanceSid, other.flexServiceInstanceSid) && Objects.equals(this.flexInstanceSid, other.flexInstanceSid) && Objects.equals(this.uiLanguage, other.uiLanguage) && Objects.equals(this.uiAttributes, other.uiAttributes) && Objects.equals(this.uiDependencies, other.uiDependencies) && Objects.equals(this.uiVersion, other.uiVersion) && Objects.equals(this.serviceVersion, other.serviceVersion) && Objects.equals(this.callRecordingEnabled, other.callRecordingEnabled) && Objects.equals(this.callRecordingWebhookUrl, other.callRecordingWebhookUrl) && Objects.equals(this.crmEnabled, other.crmEnabled) && Objects.equals(this.crmType, other.crmType) && Objects.equals(this.crmCallbackUrl, other.crmCallbackUrl) && Objects.equals(this.crmFallbackUrl, other.crmFallbackUrl) && Objects.equals(this.crmAttributes, other.crmAttributes) && Objects.equals(this.publicAttributes, other.publicAttributes) && Objects.equals(this.pluginServiceEnabled, other.pluginServiceEnabled) && Objects.equals(this.pluginServiceAttributes, other.pluginServiceAttributes) && Objects.equals(this.integrations, other.integrations) && Objects.equals(this.outboundCallFlows, other.outboundCallFlows) && Objects.equals(this.serverlessServiceSids, other.serverlessServiceSids) && Objects.equals(this.queueStatsConfiguration, other.queueStatsConfiguration) && Objects.equals(this.notifications, other.notifications) && Objects.equals(this.markdown, other.markdown) && Objects.equals(this.url, other.url) && Objects.equals(this.flexInsightsHr, other.flexInsightsHr) && Objects.equals(this.flexInsightsDrilldown, other.flexInsightsDrilldown) && Objects.equals(this.flexUrl, other.flexUrl) && Objects.equals(this.channelConfigs, other.channelConfigs) && Objects.equals(this.debuggerIntegration, other.debuggerIntegration) && Objects.equals(this.flexUiStatusReport, other.flexUiStatusReport) && Objects.equals(this.agentConvEndMethods, other.agentConvEndMethods) && Objects.equals(this.citrixVoiceVdi, other.citrixVoiceVdi) && Objects.equals(this.offlineConfig, other.offlineConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.dateCreated, this.dateUpdated, this.attributes, this.status, this.taskrouterWorkspaceSid, this.taskrouterTargetWorkflowSid, this.taskrouterTargetTaskqueueSid, this.taskrouterTaskqueues, this.taskrouterSkills, this.taskrouterWorkerChannels, this.taskrouterWorkerAttributes, this.taskrouterOfflineActivitySid, this.runtimeDomain, this.messagingServiceInstanceSid, this.chatServiceInstanceSid, this.flexServiceInstanceSid, this.flexInstanceSid, this.uiLanguage, this.uiAttributes, this.uiDependencies, this.uiVersion, this.serviceVersion, this.callRecordingEnabled, this.callRecordingWebhookUrl, this.crmEnabled, this.crmType, this.crmCallbackUrl, this.crmFallbackUrl, this.crmAttributes, this.publicAttributes, this.pluginServiceEnabled, this.pluginServiceAttributes, this.integrations, this.outboundCallFlows, this.serverlessServiceSids, this.queueStatsConfiguration, this.notifications, this.markdown, this.url, this.flexInsightsHr, this.flexInsightsDrilldown, this.flexUrl, this.channelConfigs, this.debuggerIntegration, this.flexUiStatusReport, this.agentConvEndMethods, this.citrixVoiceVdi, this.offlineConfig});
    }

    public String toString() {
        return "Configuration(accountSid=" + this.getAccountSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", attributes=" + this.getAttributes() + ", status=" + (Object)((Object)this.getStatus()) + ", taskrouterWorkspaceSid=" + this.getTaskrouterWorkspaceSid() + ", taskrouterTargetWorkflowSid=" + this.getTaskrouterTargetWorkflowSid() + ", taskrouterTargetTaskqueueSid=" + this.getTaskrouterTargetTaskqueueSid() + ", taskrouterTaskqueues=" + this.getTaskrouterTaskqueues() + ", taskrouterSkills=" + this.getTaskrouterSkills() + ", taskrouterWorkerChannels=" + this.getTaskrouterWorkerChannels() + ", taskrouterWorkerAttributes=" + this.getTaskrouterWorkerAttributes() + ", taskrouterOfflineActivitySid=" + this.getTaskrouterOfflineActivitySid() + ", runtimeDomain=" + this.getRuntimeDomain() + ", messagingServiceInstanceSid=" + this.getMessagingServiceInstanceSid() + ", chatServiceInstanceSid=" + this.getChatServiceInstanceSid() + ", flexServiceInstanceSid=" + this.getFlexServiceInstanceSid() + ", flexInstanceSid=" + this.getFlexInstanceSid() + ", uiLanguage=" + this.getUiLanguage() + ", uiAttributes=" + this.getUiAttributes() + ", uiDependencies=" + this.getUiDependencies() + ", uiVersion=" + this.getUiVersion() + ", serviceVersion=" + this.getServiceVersion() + ", callRecordingEnabled=" + this.getCallRecordingEnabled() + ", callRecordingWebhookUrl=" + this.getCallRecordingWebhookUrl() + ", crmEnabled=" + this.getCrmEnabled() + ", crmType=" + this.getCrmType() + ", crmCallbackUrl=" + this.getCrmCallbackUrl() + ", crmFallbackUrl=" + this.getCrmFallbackUrl() + ", crmAttributes=" + this.getCrmAttributes() + ", publicAttributes=" + this.getPublicAttributes() + ", pluginServiceEnabled=" + this.getPluginServiceEnabled() + ", pluginServiceAttributes=" + this.getPluginServiceAttributes() + ", integrations=" + this.getIntegrations() + ", outboundCallFlows=" + this.getOutboundCallFlows() + ", serverlessServiceSids=" + this.getServerlessServiceSids() + ", queueStatsConfiguration=" + this.getQueueStatsConfiguration() + ", notifications=" + this.getNotifications() + ", markdown=" + this.getMarkdown() + ", url=" + this.getUrl() + ", flexInsightsHr=" + this.getFlexInsightsHr() + ", flexInsightsDrilldown=" + this.getFlexInsightsDrilldown() + ", flexUrl=" + this.getFlexUrl() + ", channelConfigs=" + this.getChannelConfigs() + ", debuggerIntegration=" + this.getDebuggerIntegration() + ", flexUiStatusReport=" + this.getFlexUiStatusReport() + ", agentConvEndMethods=" + this.getAgentConvEndMethods() + ", citrixVoiceVdi=" + this.getCitrixVoiceVdi() + ", offlineConfig=" + this.getOfflineConfig() + ")";
    }

    public static enum Status {
        OK("ok"),
        INPROGRESS("inprogress"),
        NOTSTARTED("notstarted");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

