/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.AssessmentsCreator;
import com.twilio.rest.flexapi.v1.AssessmentsReader;
import com.twilio.rest.flexapi.v1.AssessmentsUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Assessments
extends Resource {
    private static final long serialVersionUID = 249351913918322L;
    private final String accountSid;
    private final String assessmentSid;
    private final BigDecimal offset;
    private final Boolean report;
    private final BigDecimal weight;
    private final String agentId;
    private final String segmentId;
    private final String userName;
    private final String userEmail;
    private final String answerText;
    private final String answerId;
    private final Map<String, Object> assessment;
    private final BigDecimal timestamp;
    private final URI url;

    public static AssessmentsCreator creator(String categorySid, String categoryName, String segmentId, String agentId, BigDecimal offset, String metricId, String metricName, String answerText, String answerId, String questionnaireSid) {
        return new AssessmentsCreator(categorySid, categoryName, segmentId, agentId, offset, metricId, metricName, answerText, answerId, questionnaireSid);
    }

    public static AssessmentsReader reader() {
        return new AssessmentsReader();
    }

    public static AssessmentsUpdater updater(String pathAssessmentSid, BigDecimal offset, String answerText, String answerId) {
        return new AssessmentsUpdater(pathAssessmentSid, offset, answerText, answerId);
    }

    public static Assessments fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Assessments.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Assessments fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Assessments.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Assessments(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="assessment_sid") String assessmentSid, @JsonProperty(value="offset") BigDecimal offset, @JsonProperty(value="report") Boolean report, @JsonProperty(value="weight") BigDecimal weight, @JsonProperty(value="agent_id") String agentId, @JsonProperty(value="segment_id") String segmentId, @JsonProperty(value="user_name") String userName, @JsonProperty(value="user_email") String userEmail, @JsonProperty(value="answer_text") String answerText, @JsonProperty(value="answer_id") String answerId, @JsonProperty(value="assessment") Map<String, Object> assessment, @JsonProperty(value="timestamp") BigDecimal timestamp, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.assessmentSid = assessmentSid;
        this.offset = offset;
        this.report = report;
        this.weight = weight;
        this.agentId = agentId;
        this.segmentId = segmentId;
        this.userName = userName;
        this.userEmail = userEmail;
        this.answerText = answerText;
        this.answerId = answerId;
        this.assessment = assessment;
        this.timestamp = timestamp;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getAssessmentSid() {
        return this.assessmentSid;
    }

    public final BigDecimal getOffset() {
        return this.offset;
    }

    public final Boolean getReport() {
        return this.report;
    }

    public final BigDecimal getWeight() {
        return this.weight;
    }

    public final String getAgentId() {
        return this.agentId;
    }

    public final String getSegmentId() {
        return this.segmentId;
    }

    public final String getUserName() {
        return this.userName;
    }

    public final String getUserEmail() {
        return this.userEmail;
    }

    public final String getAnswerText() {
        return this.answerText;
    }

    public final String getAnswerId() {
        return this.answerId;
    }

    public final Map<String, Object> getAssessment() {
        return this.assessment;
    }

    public final BigDecimal getTimestamp() {
        return this.timestamp;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assessments other = (Assessments)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.assessmentSid, other.assessmentSid) && Objects.equals(this.offset, other.offset) && Objects.equals(this.report, other.report) && Objects.equals(this.weight, other.weight) && Objects.equals(this.agentId, other.agentId) && Objects.equals(this.segmentId, other.segmentId) && Objects.equals(this.userName, other.userName) && Objects.equals(this.userEmail, other.userEmail) && Objects.equals(this.answerText, other.answerText) && Objects.equals(this.answerId, other.answerId) && Objects.equals(this.assessment, other.assessment) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.assessmentSid, this.offset, this.report, this.weight, this.agentId, this.segmentId, this.userName, this.userEmail, this.answerText, this.answerId, this.assessment, this.timestamp, this.url);
    }

    public String toString() {
        return "Assessments(accountSid=" + this.getAccountSid() + ", assessmentSid=" + this.getAssessmentSid() + ", offset=" + this.getOffset() + ", report=" + this.getReport() + ", weight=" + this.getWeight() + ", agentId=" + this.getAgentId() + ", segmentId=" + this.getSegmentId() + ", userName=" + this.getUserName() + ", userEmail=" + this.getUserEmail() + ", answerText=" + this.getAnswerText() + ", answerId=" + this.getAnswerId() + ", assessment=" + this.getAssessment() + ", timestamp=" + this.getTimestamp() + ", url=" + this.getUrl() + ")";
    }
}

