/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.events.v1.Subscription;

public class SubscriptionUpdater
extends Updater<Subscription> {
    private String pathSid;
    private String description;
    private String sinkSid;

    public SubscriptionUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public SubscriptionUpdater setDescription(String description) {
        this.description = description;
        return this;
    }

    public SubscriptionUpdater setSinkSid(String sinkSid) {
        this.sinkSid = sinkSid;
        return this;
    }

    @Override
    public Subscription update(TwilioRestClient client) {
        String path = "/v1/Subscriptions/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.EVENTS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Subscription update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Subscription.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.description != null) {
            request.addPostParam("Description", this.description);
        }
        if (this.sinkSid != null) {
            request.addPostParam("SinkSid", this.sinkSid);
        }
    }
}

