/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.events.v1.SchemaFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Schema
extends Resource {
    private static final long serialVersionUID = 100183907119303L;
    private final String id;
    private final URI url;
    private final Map<String, String> links;
    private final ZonedDateTime latestVersionDateCreated;
    private final Integer latestVersion;

    public static SchemaFetcher fetcher(String pathId) {
        return new SchemaFetcher(pathId);
    }

    public static Schema fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Schema.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Schema fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Schema.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Schema(@JsonProperty(value="id") String id, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="latest_version_date_created") String latestVersionDateCreated, @JsonProperty(value="latest_version") Integer latestVersion) {
        this.id = id;
        this.url = url;
        this.links = links;
        this.latestVersionDateCreated = DateConverter.iso8601DateTimeFromString(latestVersionDateCreated);
        this.latestVersion = latestVersion;
    }

    public final String getId() {
        return this.id;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final ZonedDateTime getLatestVersionDateCreated() {
        return this.latestVersionDateCreated;
    }

    public final Integer getLatestVersion() {
        return this.latestVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema other = (Schema)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links) && Objects.equals(this.latestVersionDateCreated, other.latestVersionDateCreated) && Objects.equals(this.latestVersion, other.latestVersion);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.url, this.links, this.latestVersionDateCreated, this.latestVersion);
    }

    public String toString() {
        return "Schema(id=" + this.getId() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ", latestVersionDateCreated=" + this.getLatestVersionDateCreated() + ", latestVersion=" + this.getLatestVersion() + ")";
    }
}

