/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.events.v1.EventType;

public class EventTypeReader
extends Reader<EventType> {
    private String schemaId;
    private Integer pageSize;

    public EventTypeReader setSchemaId(String schemaId) {
        this.schemaId = schemaId;
        return this;
    }

    public EventTypeReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<EventType> read(TwilioRestClient client) {
        return new ResourceSet<EventType>(this, client, this.firstPage(client));
    }

    @Override
    public Page<EventType> firstPage(TwilioRestClient client) {
        String path = "/v1/Types";
        Request request = new Request(HttpMethod.GET, Domains.EVENTS.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<EventType> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("EventType read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("types", response.getContent(), EventType.class, client.getObjectMapper());
    }

    @Override
    public Page<EventType> previousPage(Page<EventType> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.EVENTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<EventType> nextPage(Page<EventType> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.EVENTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<EventType> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.schemaId != null) {
            request.addQueryParam("SchemaId", this.schemaId);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

