/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.events.v1.EventTypeFetcher;
import com.twilio.rest.events.v1.EventTypeReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EventType
extends Resource {
    private static final long serialVersionUID = 236822326358907L;
    private final String type;
    private final String schemaId;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String description;
    private final URI url;
    private final Map<String, String> links;

    public static EventTypeFetcher fetcher(String pathType) {
        return new EventTypeFetcher(pathType);
    }

    public static EventTypeReader reader() {
        return new EventTypeReader();
    }

    public static EventType fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, EventType.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static EventType fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, EventType.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private EventType(@JsonProperty(value="type") String type, @JsonProperty(value="schema_id") String schemaId, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="description") String description, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.type = type;
        this.schemaId = schemaId;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.description = description;
        this.url = url;
        this.links = links;
    }

    public final String getType() {
        return this.type;
    }

    public final String getSchemaId() {
        return this.schemaId;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getDescription() {
        return this.description;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventType other = (EventType)o;
        return Objects.equals(this.type, other.type) && Objects.equals(this.schemaId, other.schemaId) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.description, other.description) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.schemaId, this.dateCreated, this.dateUpdated, this.description, this.url, this.links);
    }

    public String toString() {
        return "EventType(type=" + this.getType() + ", schemaId=" + this.getSchemaId() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", description=" + this.getDescription() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }
}

