/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.user.UserConversationDeleter;
import com.twilio.rest.conversations.v1.user.UserConversationFetcher;
import com.twilio.rest.conversations.v1.user.UserConversationReader;
import com.twilio.rest.conversations.v1.user.UserConversationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UserConversation
extends Resource {
    private static final long serialVersionUID = 269317644556189L;
    private final String accountSid;
    private final String chatServiceSid;
    private final String conversationSid;
    private final Integer unreadMessagesCount;
    private final Integer lastReadMessageIndex;
    private final String participantSid;
    private final String userSid;
    private final String friendlyName;
    private final State conversationState;
    private final Map<String, Object> timers;
    private final String attributes;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String createdBy;
    private final NotificationLevel notificationLevel;
    private final String uniqueName;
    private final URI url;
    private final Map<String, String> links;

    public static UserConversationDeleter deleter(String pathUserSid, String pathConversationSid) {
        return new UserConversationDeleter(pathUserSid, pathConversationSid);
    }

    public static UserConversationFetcher fetcher(String pathUserSid, String pathConversationSid) {
        return new UserConversationFetcher(pathUserSid, pathConversationSid);
    }

    public static UserConversationReader reader(String pathUserSid) {
        return new UserConversationReader(pathUserSid);
    }

    public static UserConversationUpdater updater(String pathUserSid, String pathConversationSid) {
        return new UserConversationUpdater(pathUserSid, pathConversationSid);
    }

    public static UserConversation fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, UserConversation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static UserConversation fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, UserConversation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private UserConversation(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="chat_service_sid") String chatServiceSid, @JsonProperty(value="conversation_sid") String conversationSid, @JsonProperty(value="unread_messages_count") Integer unreadMessagesCount, @JsonProperty(value="last_read_message_index") Integer lastReadMessageIndex, @JsonProperty(value="participant_sid") String participantSid, @JsonProperty(value="user_sid") String userSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="conversation_state") State conversationState, @JsonProperty(value="timers") Map<String, Object> timers, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="created_by") String createdBy, @JsonProperty(value="notification_level") NotificationLevel notificationLevel, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.chatServiceSid = chatServiceSid;
        this.conversationSid = conversationSid;
        this.unreadMessagesCount = unreadMessagesCount;
        this.lastReadMessageIndex = lastReadMessageIndex;
        this.participantSid = participantSid;
        this.userSid = userSid;
        this.friendlyName = friendlyName;
        this.conversationState = conversationState;
        this.timers = timers;
        this.attributes = attributes;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.createdBy = createdBy;
        this.notificationLevel = notificationLevel;
        this.uniqueName = uniqueName;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    public final String getConversationSid() {
        return this.conversationSid;
    }

    public final Integer getUnreadMessagesCount() {
        return this.unreadMessagesCount;
    }

    public final Integer getLastReadMessageIndex() {
        return this.lastReadMessageIndex;
    }

    public final String getParticipantSid() {
        return this.participantSid;
    }

    public final String getUserSid() {
        return this.userSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final State getConversationState() {
        return this.conversationState;
    }

    public final Map<String, Object> getTimers() {
        return this.timers;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getCreatedBy() {
        return this.createdBy;
    }

    public final NotificationLevel getNotificationLevel() {
        return this.notificationLevel;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserConversation other = (UserConversation)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.chatServiceSid, other.chatServiceSid) && Objects.equals(this.conversationSid, other.conversationSid) && Objects.equals(this.unreadMessagesCount, other.unreadMessagesCount) && Objects.equals(this.lastReadMessageIndex, other.lastReadMessageIndex) && Objects.equals(this.participantSid, other.participantSid) && Objects.equals(this.userSid, other.userSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals((Object)this.conversationState, (Object)other.conversationState) && Objects.equals(this.timers, other.timers) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.createdBy, other.createdBy) && Objects.equals((Object)this.notificationLevel, (Object)other.notificationLevel) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.chatServiceSid, this.conversationSid, this.unreadMessagesCount, this.lastReadMessageIndex, this.participantSid, this.userSid, this.friendlyName, this.conversationState, this.timers, this.attributes, this.dateCreated, this.dateUpdated, this.createdBy, this.notificationLevel, this.uniqueName, this.url, this.links});
    }

    public String toString() {
        return "UserConversation(accountSid=" + this.getAccountSid() + ", chatServiceSid=" + this.getChatServiceSid() + ", conversationSid=" + this.getConversationSid() + ", unreadMessagesCount=" + this.getUnreadMessagesCount() + ", lastReadMessageIndex=" + this.getLastReadMessageIndex() + ", participantSid=" + this.getParticipantSid() + ", userSid=" + this.getUserSid() + ", friendlyName=" + this.getFriendlyName() + ", conversationState=" + (Object)((Object)this.getConversationState()) + ", timers=" + this.getTimers() + ", attributes=" + this.getAttributes() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", createdBy=" + this.getCreatedBy() + ", notificationLevel=" + (Object)((Object)this.getNotificationLevel()) + ", uniqueName=" + this.getUniqueName() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }

    public static enum NotificationLevel {
        DEFAULT("default"),
        MUTED("muted");

        private final String value;

        private NotificationLevel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static NotificationLevel forValue(String value) {
            return (NotificationLevel)Promoter.enumFromString((String)value, (Enum[])NotificationLevel.values());
        }
    }

    public static enum State {
        INACTIVE("inactive"),
        ACTIVE("active"),
        CLOSED("closed");

        private final String value;

        private State(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static State forValue(String value) {
            return (State)Promoter.enumFromString((String)value, (Enum[])State.values());
        }
    }
}

