/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.conversation.message;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.conversation.message.DeliveryReceipt;

public class DeliveryReceiptFetcher
extends Fetcher<DeliveryReceipt> {
    private String pathChatServiceSid;
    private String pathConversationSid;
    private String pathMessageSid;
    private String pathSid;

    public DeliveryReceiptFetcher(String pathChatServiceSid, String pathConversationSid, String pathMessageSid, String pathSid) {
        this.pathChatServiceSid = pathChatServiceSid;
        this.pathConversationSid = pathConversationSid;
        this.pathMessageSid = pathMessageSid;
        this.pathSid = pathSid;
    }

    @Override
    public DeliveryReceipt fetch(TwilioRestClient client) {
        String path = "/v1/Services/{ChatServiceSid}/Conversations/{ConversationSid}/Messages/{MessageSid}/Receipts/{Sid}";
        path = path.replace("{ChatServiceSid}", this.pathChatServiceSid.toString());
        path = path.replace("{ConversationSid}", this.pathConversationSid.toString());
        path = path.replace("{MessageSid}", this.pathMessageSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.CONVERSATIONS.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeliveryReceipt fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return DeliveryReceipt.fromJson(response.getStream(), client.getObjectMapper());
    }
}

