/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.conversation;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.conversation.Participant;
import java.time.ZonedDateTime;

public class ParticipantUpdater
extends Updater<Participant> {
    private String pathChatServiceSid;
    private String pathConversationSid;
    private String pathSid;
    private Participant.WebhookEnabledType xTwilioWebhookEnabled;
    private ZonedDateTime dateCreated;
    private ZonedDateTime dateUpdated;
    private String identity;
    private String attributes;
    private String roleSid;
    private String messagingBindingProxyAddress;
    private String messagingBindingProjectedAddress;
    private Integer lastReadMessageIndex;
    private String lastReadTimestamp;

    public ParticipantUpdater(String pathChatServiceSid, String pathConversationSid, String pathSid) {
        this.pathChatServiceSid = pathChatServiceSid;
        this.pathConversationSid = pathConversationSid;
        this.pathSid = pathSid;
    }

    public ParticipantUpdater setXTwilioWebhookEnabled(Participant.WebhookEnabledType xTwilioWebhookEnabled) {
        this.xTwilioWebhookEnabled = xTwilioWebhookEnabled;
        return this;
    }

    public ParticipantUpdater setDateCreated(ZonedDateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public ParticipantUpdater setDateUpdated(ZonedDateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public ParticipantUpdater setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public ParticipantUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public ParticipantUpdater setRoleSid(String roleSid) {
        this.roleSid = roleSid;
        return this;
    }

    public ParticipantUpdater setMessagingBindingProxyAddress(String messagingBindingProxyAddress) {
        this.messagingBindingProxyAddress = messagingBindingProxyAddress;
        return this;
    }

    public ParticipantUpdater setMessagingBindingProjectedAddress(String messagingBindingProjectedAddress) {
        this.messagingBindingProjectedAddress = messagingBindingProjectedAddress;
        return this;
    }

    public ParticipantUpdater setLastReadMessageIndex(Integer lastReadMessageIndex) {
        this.lastReadMessageIndex = lastReadMessageIndex;
        return this;
    }

    public ParticipantUpdater setLastReadTimestamp(String lastReadTimestamp) {
        this.lastReadTimestamp = lastReadTimestamp;
        return this;
    }

    @Override
    public Participant update(TwilioRestClient client) {
        String path = "/v1/Services/{ChatServiceSid}/Conversations/{ConversationSid}/Participants/{Sid}";
        path = path.replace("{ChatServiceSid}", this.pathChatServiceSid.toString());
        path = path.replace("{ConversationSid}", this.pathConversationSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toInstant().toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toInstant().toString());
        }
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.roleSid != null) {
            request.addPostParam("RoleSid", this.roleSid);
        }
        if (this.messagingBindingProxyAddress != null) {
            request.addPostParam("MessagingBinding.ProxyAddress", this.messagingBindingProxyAddress);
        }
        if (this.messagingBindingProjectedAddress != null) {
            request.addPostParam("MessagingBinding.ProjectedAddress", this.messagingBindingProjectedAddress);
        }
        if (this.lastReadMessageIndex != null) {
            request.addPostParam("LastReadMessageIndex", this.lastReadMessageIndex.toString());
        }
        if (this.lastReadTimestamp != null) {
            request.addPostParam("LastReadTimestamp", this.lastReadTimestamp);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.xTwilioWebhookEnabled != null) {
            request.addHeaderParam("X-Twilio-Webhook-Enabled", this.xTwilioWebhookEnabled.toString());
        }
    }
}

