/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.configuration;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.configuration.Notification;

public class NotificationFetcher
extends Fetcher<Notification> {
    private String pathChatServiceSid;

    public NotificationFetcher(String pathChatServiceSid) {
        this.pathChatServiceSid = pathChatServiceSid;
    }

    @Override
    public Notification fetch(TwilioRestClient client) {
        String path = "/v1/Services/{ChatServiceSid}/Configuration/Notifications";
        path = path.replace("{ChatServiceSid}", this.pathChatServiceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.CONVERSATIONS.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Notification fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Notification.fromJson(response.getStream(), client.getObjectMapper());
    }
}

