/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.service.ConversationCreator;
import com.twilio.rest.conversations.v1.service.ConversationDeleter;
import com.twilio.rest.conversations.v1.service.ConversationFetcher;
import com.twilio.rest.conversations.v1.service.ConversationReader;
import com.twilio.rest.conversations.v1.service.ConversationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Conversation
extends Resource {
    private static final long serialVersionUID = 208929192266810L;
    private final String accountSid;
    private final String chatServiceSid;
    private final String messagingServiceSid;
    private final String sid;
    private final String friendlyName;
    private final String uniqueName;
    private final String attributes;
    private final State state;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final Map<String, Object> timers;
    private final URI url;
    private final Map<String, String> links;
    private final Map<String, Object> bindings;

    public static ConversationCreator creator(String pathChatServiceSid) {
        return new ConversationCreator(pathChatServiceSid);
    }

    public static ConversationDeleter deleter(String pathChatServiceSid, String pathSid) {
        return new ConversationDeleter(pathChatServiceSid, pathSid);
    }

    public static ConversationFetcher fetcher(String pathChatServiceSid, String pathSid) {
        return new ConversationFetcher(pathChatServiceSid, pathSid);
    }

    public static ConversationReader reader(String pathChatServiceSid) {
        return new ConversationReader(pathChatServiceSid);
    }

    public static ConversationUpdater updater(String pathChatServiceSid, String pathSid) {
        return new ConversationUpdater(pathChatServiceSid, pathSid);
    }

    public static Conversation fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Conversation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Conversation fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Conversation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Conversation(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="chat_service_sid") String chatServiceSid, @JsonProperty(value="messaging_service_sid") String messagingServiceSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="state") State state, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="timers") Map<String, Object> timers, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="bindings") Map<String, Object> bindings) {
        this.accountSid = accountSid;
        this.chatServiceSid = chatServiceSid;
        this.messagingServiceSid = messagingServiceSid;
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.uniqueName = uniqueName;
        this.attributes = attributes;
        this.state = state;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.timers = timers;
        this.url = url;
        this.links = links;
        this.bindings = bindings;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final State getState() {
        return this.state;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Map<String, Object> getTimers() {
        return this.timers;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final Map<String, Object> getBindings() {
        return this.bindings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conversation other = (Conversation)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.chatServiceSid, other.chatServiceSid) && Objects.equals(this.messagingServiceSid, other.messagingServiceSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.attributes, other.attributes) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.timers, other.timers) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links) && Objects.equals(this.bindings, other.bindings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.chatServiceSid, this.messagingServiceSid, this.sid, this.friendlyName, this.uniqueName, this.attributes, this.state, this.dateCreated, this.dateUpdated, this.timers, this.url, this.links, this.bindings});
    }

    public String toString() {
        return "Conversation(accountSid=" + this.getAccountSid() + ", chatServiceSid=" + this.getChatServiceSid() + ", messagingServiceSid=" + this.getMessagingServiceSid() + ", sid=" + this.getSid() + ", friendlyName=" + this.getFriendlyName() + ", uniqueName=" + this.getUniqueName() + ", attributes=" + this.getAttributes() + ", state=" + (Object)((Object)this.getState()) + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", timers=" + this.getTimers() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ", bindings=" + this.getBindings() + ")";
    }

    public static enum State {
        INACTIVE("inactive"),
        ACTIVE("active"),
        CLOSED("closed");

        private final String value;

        private State(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static State forValue(String value) {
            return (State)Promoter.enumFromString((String)value, (Enum[])State.values());
        }
    }

    public static enum WebhookEnabledType {
        TRUE("true"),
        FALSE("false");

        private final String value;

        private WebhookEnabledType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static WebhookEnabledType forValue(String value) {
            return (WebhookEnabledType)Promoter.enumFromString((String)value, (Enum[])WebhookEnabledType.values());
        }
    }
}

