/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.Conversation;
import java.time.ZonedDateTime;

public class ConversationUpdater
extends Updater<Conversation> {
    private String pathSid;
    private Conversation.WebhookEnabledType xTwilioWebhookEnabled;
    private String friendlyName;
    private ZonedDateTime dateCreated;
    private ZonedDateTime dateUpdated;
    private String attributes;
    private String messagingServiceSid;
    private Conversation.State state;
    private String timersInactive;
    private String timersClosed;
    private String uniqueName;
    private String bindingsEmailAddress;
    private String bindingsEmailName;

    public ConversationUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ConversationUpdater setXTwilioWebhookEnabled(Conversation.WebhookEnabledType xTwilioWebhookEnabled) {
        this.xTwilioWebhookEnabled = xTwilioWebhookEnabled;
        return this;
    }

    public ConversationUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ConversationUpdater setDateCreated(ZonedDateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public ConversationUpdater setDateUpdated(ZonedDateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public ConversationUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public ConversationUpdater setMessagingServiceSid(String messagingServiceSid) {
        this.messagingServiceSid = messagingServiceSid;
        return this;
    }

    public ConversationUpdater setState(Conversation.State state) {
        this.state = state;
        return this;
    }

    public ConversationUpdater setTimersInactive(String timersInactive) {
        this.timersInactive = timersInactive;
        return this;
    }

    public ConversationUpdater setTimersClosed(String timersClosed) {
        this.timersClosed = timersClosed;
        return this;
    }

    public ConversationUpdater setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public ConversationUpdater setBindingsEmailAddress(String bindingsEmailAddress) {
        this.bindingsEmailAddress = bindingsEmailAddress;
        return this;
    }

    public ConversationUpdater setBindingsEmailName(String bindingsEmailName) {
        this.bindingsEmailName = bindingsEmailName;
        return this;
    }

    @Override
    public Conversation update(TwilioRestClient client) {
        String path = "/v1/Conversations/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Conversation update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Conversation.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toInstant().toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toInstant().toString());
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.messagingServiceSid != null) {
            request.addPostParam("MessagingServiceSid", this.messagingServiceSid);
        }
        if (this.state != null) {
            request.addPostParam("State", this.state.toString());
        }
        if (this.timersInactive != null) {
            request.addPostParam("Timers.Inactive", this.timersInactive);
        }
        if (this.timersClosed != null) {
            request.addPostParam("Timers.Closed", this.timersClosed);
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.bindingsEmailAddress != null) {
            request.addPostParam("Bindings.Email.Address", this.bindingsEmailAddress);
        }
        if (this.bindingsEmailName != null) {
            request.addPostParam("Bindings.Email.Name", this.bindingsEmailName);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.xTwilioWebhookEnabled != null) {
            request.addHeaderParam("X-Twilio-Webhook-Enabled", this.xTwilioWebhookEnabled.toString());
        }
    }
}

