/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.AddressConfigurationCreator;
import com.twilio.rest.conversations.v1.AddressConfigurationDeleter;
import com.twilio.rest.conversations.v1.AddressConfigurationFetcher;
import com.twilio.rest.conversations.v1.AddressConfigurationReader;
import com.twilio.rest.conversations.v1.AddressConfigurationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AddressConfiguration
extends Resource {
    private static final long serialVersionUID = 162346024858734L;
    private final String sid;
    private final String accountSid;
    private final String type;
    private final String address;
    private final String friendlyName;
    private final Map<String, Object> autoCreation;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final String addressCountry;

    public static AddressConfigurationCreator creator(Type type, String address) {
        return new AddressConfigurationCreator(type, address);
    }

    public static AddressConfigurationDeleter deleter(String pathSid) {
        return new AddressConfigurationDeleter(pathSid);
    }

    public static AddressConfigurationFetcher fetcher(String pathSid) {
        return new AddressConfigurationFetcher(pathSid);
    }

    public static AddressConfigurationReader reader() {
        return new AddressConfigurationReader();
    }

    public static AddressConfigurationUpdater updater(String pathSid) {
        return new AddressConfigurationUpdater(pathSid);
    }

    public static AddressConfiguration fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AddressConfiguration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AddressConfiguration fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AddressConfiguration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AddressConfiguration(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="type") String type, @JsonProperty(value="address") String address, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="auto_creation") Map<String, Object> autoCreation, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="address_country") String addressCountry) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.type = type;
        this.address = address;
        this.friendlyName = friendlyName;
        this.autoCreation = autoCreation;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.addressCountry = addressCountry;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getType() {
        return this.type;
    }

    public final String getAddress() {
        return this.address;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Map<String, Object> getAutoCreation() {
        return this.autoCreation;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getAddressCountry() {
        return this.addressCountry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressConfiguration other = (AddressConfiguration)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.type, other.type) && Objects.equals(this.address, other.address) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.autoCreation, other.autoCreation) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.addressCountry, other.addressCountry);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.type, this.address, this.friendlyName, this.autoCreation, this.dateCreated, this.dateUpdated, this.url, this.addressCountry);
    }

    public String toString() {
        return "AddressConfiguration(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", type=" + this.getType() + ", address=" + this.getAddress() + ", friendlyName=" + this.getFriendlyName() + ", autoCreation=" + this.getAutoCreation() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ", addressCountry=" + this.getAddressCountry() + ")";
    }

    public static enum Type {
        SMS("sms"),
        WHATSAPP("whatsapp"),
        MESSENGER("messenger"),
        GBM("gbm"),
        EMAIL("email");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Type forValue(String value) {
            return (Type)Promoter.enumFromString((String)value, (Enum[])Type.values());
        }
    }

    public static enum Method {
        GET("GET"),
        POST("POST");

        private final String value;

        private Method(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Method forValue(String value) {
            return (Method)Promoter.enumFromString((String)value, (Enum[])Method.values());
        }
    }

    public static enum AutoCreationType {
        WEBHOOK("webhook"),
        STUDIO("studio"),
        DEFAULT("default");

        private final String value;

        private AutoCreationType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static AutoCreationType forValue(String value) {
            return (AutoCreationType)Promoter.enumFromString((String)value, (Enum[])AutoCreationType.values());
        }
    }
}

