/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v3;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v3.Channel;

public class ChannelUpdater
extends Updater<Channel> {
    private String pathServiceSid;
    private String pathSid;
    private Channel.WebhookEnabledType xTwilioWebhookEnabled;
    private Channel.ChannelType type;
    private String messagingServiceSid;

    public ChannelUpdater(String pathServiceSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSid = pathSid;
    }

    public ChannelUpdater setXTwilioWebhookEnabled(Channel.WebhookEnabledType xTwilioWebhookEnabled) {
        this.xTwilioWebhookEnabled = xTwilioWebhookEnabled;
        return this;
    }

    public ChannelUpdater setType(Channel.ChannelType type) {
        this.type = type;
        return this;
    }

    public ChannelUpdater setMessagingServiceSid(String messagingServiceSid) {
        this.messagingServiceSid = messagingServiceSid;
        return this;
    }

    @Override
    public Channel update(TwilioRestClient client) {
        String path = "/v3/Services/{ServiceSid}/Channels/{Sid}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.CHAT.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Channel update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Channel.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.type != null) {
            request.addPostParam("Type", this.type.toString());
        }
        if (this.messagingServiceSid != null) {
            request.addPostParam("MessagingServiceSid", this.messagingServiceSid);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.xTwilioWebhookEnabled != null) {
            request.addHeaderParam("X-Twilio-Webhook-Enabled", this.xTwilioWebhookEnabled.toString());
        }
    }
}

