/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v2.service.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.chat.v2.service.channel.MemberCreator;
import com.twilio.rest.chat.v2.service.channel.MemberDeleter;
import com.twilio.rest.chat.v2.service.channel.MemberFetcher;
import com.twilio.rest.chat.v2.service.channel.MemberReader;
import com.twilio.rest.chat.v2.service.channel.MemberUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Member
extends Resource {
    private static final long serialVersionUID = 220317594144302L;
    private final String sid;
    private final String accountSid;
    private final String channelSid;
    private final String serviceSid;
    private final String identity;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String roleSid;
    private final Integer lastConsumedMessageIndex;
    private final ZonedDateTime lastConsumptionTimestamp;
    private final URI url;
    private final String attributes;

    public static MemberCreator creator(String pathServiceSid, String pathChannelSid, String identity) {
        return new MemberCreator(pathServiceSid, pathChannelSid, identity);
    }

    public static MemberDeleter deleter(String pathServiceSid, String pathChannelSid, String pathSid) {
        return new MemberDeleter(pathServiceSid, pathChannelSid, pathSid);
    }

    public static MemberFetcher fetcher(String pathServiceSid, String pathChannelSid, String pathSid) {
        return new MemberFetcher(pathServiceSid, pathChannelSid, pathSid);
    }

    public static MemberReader reader(String pathServiceSid, String pathChannelSid) {
        return new MemberReader(pathServiceSid, pathChannelSid);
    }

    public static MemberUpdater updater(String pathServiceSid, String pathChannelSid, String pathSid) {
        return new MemberUpdater(pathServiceSid, pathChannelSid, pathSid);
    }

    public static Member fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Member.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Member fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Member.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Member(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="channel_sid") String channelSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="identity") String identity, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="role_sid") String roleSid, @JsonProperty(value="last_consumed_message_index") Integer lastConsumedMessageIndex, @JsonProperty(value="last_consumption_timestamp") String lastConsumptionTimestamp, @JsonProperty(value="url") URI url, @JsonProperty(value="attributes") String attributes) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.channelSid = channelSid;
        this.serviceSid = serviceSid;
        this.identity = identity;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.roleSid = roleSid;
        this.lastConsumedMessageIndex = lastConsumedMessageIndex;
        this.lastConsumptionTimestamp = DateConverter.iso8601DateTimeFromString(lastConsumptionTimestamp);
        this.url = url;
        this.attributes = attributes;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChannelSid() {
        return this.channelSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getRoleSid() {
        return this.roleSid;
    }

    public final Integer getLastConsumedMessageIndex() {
        return this.lastConsumedMessageIndex;
    }

    public final ZonedDateTime getLastConsumptionTimestamp() {
        return this.lastConsumptionTimestamp;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member other = (Member)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.channelSid, other.channelSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.roleSid, other.roleSid) && Objects.equals(this.lastConsumedMessageIndex, other.lastConsumedMessageIndex) && Objects.equals(this.lastConsumptionTimestamp, other.lastConsumptionTimestamp) && Objects.equals(this.url, other.url) && Objects.equals(this.attributes, other.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.channelSid, this.serviceSid, this.identity, this.dateCreated, this.dateUpdated, this.roleSid, this.lastConsumedMessageIndex, this.lastConsumptionTimestamp, this.url, this.attributes);
    }

    public String toString() {
        return "Member(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", channelSid=" + this.getChannelSid() + ", serviceSid=" + this.getServiceSid() + ", identity=" + this.getIdentity() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", roleSid=" + this.getRoleSid() + ", lastConsumedMessageIndex=" + this.getLastConsumedMessageIndex() + ", lastConsumptionTimestamp=" + this.getLastConsumptionTimestamp() + ", url=" + this.getUrl() + ", attributes=" + this.getAttributes() + ")";
    }

    public static enum WebhookEnabledType {
        TRUE("true"),
        FALSE("false");

        private final String value;

        private WebhookEnabledType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static WebhookEnabledType forValue(String value) {
            return (WebhookEnabledType)Promoter.enumFromString((String)value, (Enum[])WebhookEnabledType.values());
        }
    }
}

