/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.bulkexports.v1.export;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.bulkexports.v1.export.ExportCustomJob;

public class ExportCustomJobCreator
extends Creator<ExportCustomJob> {
    private String pathResourceType;
    private String startDay;
    private String endDay;
    private String friendlyName;
    private String webhookUrl;
    private String webhookMethod;
    private String email;

    public ExportCustomJobCreator(String pathResourceType, String startDay, String endDay, String friendlyName) {
        this.pathResourceType = pathResourceType;
        this.startDay = startDay;
        this.endDay = endDay;
        this.friendlyName = friendlyName;
    }

    public ExportCustomJobCreator setStartDay(String startDay) {
        this.startDay = startDay;
        return this;
    }

    public ExportCustomJobCreator setEndDay(String endDay) {
        this.endDay = endDay;
        return this;
    }

    public ExportCustomJobCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ExportCustomJobCreator setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    public ExportCustomJobCreator setWebhookMethod(String webhookMethod) {
        this.webhookMethod = webhookMethod;
        return this;
    }

    public ExportCustomJobCreator setEmail(String email) {
        this.email = email;
        return this;
    }

    @Override
    public ExportCustomJob create(TwilioRestClient client) {
        String path = "/v1/Exports/{ResourceType}/Jobs";
        path = path.replace("{ResourceType}", this.pathResourceType.toString());
        path = path.replace("{StartDay}", this.startDay.toString());
        path = path.replace("{EndDay}", this.endDay.toString());
        path = path.replace("{FriendlyName}", this.friendlyName.toString());
        Request request = new Request(HttpMethod.POST, Domains.BULKEXPORTS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ExportCustomJob creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ExportCustomJob.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.startDay != null) {
            request.addPostParam("StartDay", this.startDay);
        }
        if (this.endDay != null) {
            request.addPostParam("EndDay", this.endDay);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.webhookUrl != null) {
            request.addPostParam("WebhookUrl", this.webhookUrl);
        }
        if (this.webhookMethod != null) {
            request.addPostParam("WebhookMethod", this.webhookMethod);
        }
        if (this.email != null) {
            request.addPostParam("Email", this.email);
        }
    }
}

