/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.bulkexports.v1.export;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.bulkexports.v1.export.Day;

public class DayReader
extends Reader<Day> {
    private String pathResourceType;
    private Integer pageSize;

    public DayReader(String pathResourceType) {
        this.pathResourceType = pathResourceType;
    }

    public DayReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Day> read(TwilioRestClient client) {
        return new ResourceSet<Day>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Day> firstPage(TwilioRestClient client) {
        String path = "/v1/Exports/{ResourceType}/Days";
        path = path.replace("{ResourceType}", this.pathResourceType.toString());
        Request request = new Request(HttpMethod.GET, Domains.BULKEXPORTS.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Day> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Day read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("days", response.getContent(), Day.class, client.getObjectMapper());
    }

    @Override
    public Page<Day> previousPage(Page<Day> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.BULKEXPORTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Day> nextPage(Page<Day> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.BULKEXPORTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Day> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

