/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.call.UserDefinedMessage;

public class UserDefinedMessageCreator
extends Creator<UserDefinedMessage> {
    private String pathCallSid;
    private String content;
    private String pathAccountSid;
    private String idempotencyKey;

    public UserDefinedMessageCreator(String pathCallSid, String content) {
        this.pathCallSid = pathCallSid;
        this.content = content;
    }

    public UserDefinedMessageCreator(String pathAccountSid, String pathCallSid, String content) {
        this.pathAccountSid = pathAccountSid;
        this.pathCallSid = pathCallSid;
        this.content = content;
    }

    public UserDefinedMessageCreator setContent(String content) {
        this.content = content;
        return this;
    }

    public UserDefinedMessageCreator setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @Override
    public UserDefinedMessage create(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/UserDefinedMessages.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{CallSid}", this.pathCallSid.toString());
        path = path.replace("{Content}", this.content.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UserDefinedMessage creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return UserDefinedMessage.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.content != null) {
            request.addPostParam("Content", this.content);
        }
        if (this.idempotencyKey != null) {
            request.addPostParam("IdempotencyKey", this.idempotencyKey);
        }
    }
}

