/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.OutgoingCallerIdDeleter;
import com.twilio.rest.api.v2010.account.OutgoingCallerIdFetcher;
import com.twilio.rest.api.v2010.account.OutgoingCallerIdReader;
import com.twilio.rest.api.v2010.account.OutgoingCallerIdUpdater;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OutgoingCallerId
extends Resource {
    private static final long serialVersionUID = 75956517535233L;
    private final String sid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String friendlyName;
    private final String accountSid;
    private final PhoneNumber phoneNumber;
    private final String uri;

    public static OutgoingCallerIdDeleter deleter(String pathSid) {
        return new OutgoingCallerIdDeleter(pathSid);
    }

    public static OutgoingCallerIdDeleter deleter(String pathAccountSid, String pathSid) {
        return new OutgoingCallerIdDeleter(pathAccountSid, pathSid);
    }

    public static OutgoingCallerIdFetcher fetcher(String pathSid) {
        return new OutgoingCallerIdFetcher(pathSid);
    }

    public static OutgoingCallerIdFetcher fetcher(String pathAccountSid, String pathSid) {
        return new OutgoingCallerIdFetcher(pathAccountSid, pathSid);
    }

    public static OutgoingCallerIdReader reader() {
        return new OutgoingCallerIdReader();
    }

    public static OutgoingCallerIdReader reader(String pathAccountSid) {
        return new OutgoingCallerIdReader(pathAccountSid);
    }

    public static OutgoingCallerIdUpdater updater(String pathSid) {
        return new OutgoingCallerIdUpdater(pathSid);
    }

    public static OutgoingCallerIdUpdater updater(String pathAccountSid, String pathSid) {
        return new OutgoingCallerIdUpdater(pathAccountSid, pathSid);
    }

    public static OutgoingCallerId fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, OutgoingCallerId.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static OutgoingCallerId fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, OutgoingCallerId.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private OutgoingCallerId(@JsonProperty(value="sid") String sid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="phone_number") PhoneNumber phoneNumber, @JsonProperty(value="uri") String uri) {
        this.sid = sid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.accountSid = accountSid;
        this.phoneNumber = phoneNumber;
        this.uri = uri;
    }

    public final String getSid() {
        return this.sid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutgoingCallerId other = (OutgoingCallerId)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.dateCreated, this.dateUpdated, this.friendlyName, this.accountSid, this.phoneNumber, this.uri);
    }

    public String toString() {
        return "OutgoingCallerId(sid=" + this.getSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", friendlyName=" + this.getFriendlyName() + ", accountSid=" + this.getAccountSid() + ", phoneNumber=" + this.getPhoneNumber() + ", uri=" + this.getUri() + ")";
    }
}

