/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.AvailablePhoneNumberCountry;

public class AvailablePhoneNumberCountryFetcher
extends Fetcher<AvailablePhoneNumberCountry> {
    private String pathCountryCode;
    private String pathAccountSid;

    public AvailablePhoneNumberCountryFetcher(String pathCountryCode) {
        this.pathCountryCode = pathCountryCode;
    }

    public AvailablePhoneNumberCountryFetcher(String pathAccountSid, String pathCountryCode) {
        this.pathAccountSid = pathAccountSid;
        this.pathCountryCode = pathCountryCode;
    }

    @Override
    public AvailablePhoneNumberCountry fetch(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/AvailablePhoneNumbers/{CountryCode}.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{CountryCode}", this.pathCountryCode.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AvailablePhoneNumberCountry fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return AvailablePhoneNumberCountry.fromJson(response.getStream(), client.getObjectMapper());
    }
}

