/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.accounts.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.accounts.v1.SecondaryAuthTokenCreator;
import com.twilio.rest.accounts.v1.SecondaryAuthTokenDeleter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SecondaryAuthToken
extends Resource {
    private static final long serialVersionUID = 191219471550314L;
    private final String accountSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String secondaryAuthToken;
    private final URI url;

    public static SecondaryAuthTokenCreator creator() {
        return new SecondaryAuthTokenCreator();
    }

    public static SecondaryAuthTokenDeleter deleter() {
        return new SecondaryAuthTokenDeleter();
    }

    public static SecondaryAuthToken fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SecondaryAuthToken.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SecondaryAuthToken fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SecondaryAuthToken.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SecondaryAuthToken(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="secondary_auth_token") String secondaryAuthToken, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.secondaryAuthToken = secondaryAuthToken;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getSecondaryAuthToken() {
        return this.secondaryAuthToken;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecondaryAuthToken other = (SecondaryAuthToken)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.secondaryAuthToken, other.secondaryAuthToken) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.secondaryAuthToken, this.url);
    }

    public String toString() {
        return "SecondaryAuthToken(accountSid=" + this.getAccountSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", secondaryAuthToken=" + this.getSecondaryAuthToken() + ", url=" + this.getUrl() + ")";
    }
}

