/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http;

import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiException;
import com.twilio.exception.InvalidRequestException;
import com.twilio.http.HttpMethod;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Request {
    private static final String DEFAULT_REGION = "us1";
    public static final String QUERY_STRING_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String QUERY_STRING_DATE_FORMAT = "yyyy-MM-dd";
    private final HttpMethod method;
    private final String url;
    private final Map<String, List<String>> queryParams;
    private final Map<String, List<String>> postParams;
    private final Map<String, List<String>> headerParams;
    private String region;
    private String edge;
    private String username;
    private String password;
    private List<String> userAgentExtensions;
    private EnumConstants.ContentType contentType;
    private String body;

    public Request(HttpMethod method, String url) {
        this.method = method;
        this.url = url;
        this.queryParams = new HashMap<String, List<String>>();
        this.postParams = new HashMap<String, List<String>>();
        this.headerParams = new HashMap<String, List<String>>();
    }

    public Request(HttpMethod method, String domain, String uri) {
        this(method, domain, uri, null);
    }

    public Request(HttpMethod method, String domain, String uri, String region) {
        this.method = method;
        this.url = "https://" + domain + ".twilio.com" + uri;
        this.region = region;
        this.queryParams = new HashMap<String, List<String>>();
        this.postParams = new HashMap<String, List<String>>();
        this.headerParams = new HashMap<String, List<String>>();
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setAuth(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setEdge(String edge) {
        this.edge = edge;
    }

    public void setUserAgentExtensions(List<String> userAgentExtensions) {
        this.userAgentExtensions = userAgentExtensions;
    }

    public List<String> getUserAgentExtensions() {
        return this.userAgentExtensions;
    }

    public EnumConstants.ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(EnumConstants.ContentType contentType) {
        this.contentType = contentType;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getAuthString() {
        String credentials = this.username + ":" + this.password;
        String encoded = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.US_ASCII));
        return "Basic " + encoded;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean requiresAuthentication() {
        return this.username != null || this.password != null;
    }

    public URL constructURL() {
        String params = this.encodeQueryParams();
        String stringUri = this.buildURL();
        if (params.length() > 0) {
            stringUri = stringUri + "?" + params;
        }
        try {
            URI uri = new URI(stringUri);
            return uri.toURL();
        }
        catch (URISyntaxException e) {
            throw new ApiException("Bad URI: " + e.getMessage());
        }
        catch (MalformedURLException e) {
            throw new ApiException("Bad URL: " + e.getMessage());
        }
    }

    private String buildURL() {
        try {
            URL parsedUrl = new URL(this.url);
            String host = parsedUrl.getHost();
            String[] pieces = host.split("\\.");
            if (pieces.length > 1) {
                String product = pieces[0];
                String domain = Request.joinIgnoreNull(".", pieces[pieces.length - 2], pieces[pieces.length - 1]);
                String targetRegion = this.region;
                String targetEdge = this.edge;
                if (pieces.length == 4) {
                    targetRegion = targetRegion != null ? targetRegion : pieces[1];
                } else if (pieces.length == 5) {
                    targetEdge = targetEdge != null ? targetEdge : pieces[1];
                    String string = targetRegion = targetRegion != null ? targetRegion : pieces[2];
                }
                if (targetEdge != null && targetRegion == null) {
                    targetRegion = DEFAULT_REGION;
                }
                host = Request.joinIgnoreNull(".", product, targetEdge, targetRegion, domain);
            }
            String urlPort = parsedUrl.getPort() != -1 ? ":" + parsedUrl.getPort() : null;
            String protocol = parsedUrl.getProtocol() + "://";
            CharSequence[] pathPieces = parsedUrl.getPath().split("/");
            for (int i = 0; i < pathPieces.length; ++i) {
                pathPieces[i] = URLEncoder.encode((String)pathPieces[i], "UTF-8");
            }
            String encodedPath = String.join((CharSequence)"/", pathPieces);
            String query = parsedUrl.getQuery() != null ? "?" + parsedUrl.getQuery() : null;
            String ref = parsedUrl.getRef() != null ? "#" + parsedUrl.getRef() : null;
            String credentials = parsedUrl.getUserInfo() != null ? parsedUrl.getUserInfo() + "@" : null;
            return Request.joinIgnoreNull("", protocol, credentials, host, urlPort, encodedPath, query, ref);
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new ApiException("Bad URL: " + e.getMessage());
        }
    }

    public void addQueryDateRange(String name, LocalDate lowerBound, LocalDate upperBound) {
        String value;
        if (lowerBound != null) {
            value = lowerBound.toString();
            this.addQueryParam(name + ">", value);
        }
        if (upperBound != null) {
            value = upperBound.toString();
            this.addQueryParam(name + "<", value);
        }
    }

    public void addQueryDateTimeRange(String name, ZonedDateTime lowerBound, ZonedDateTime upperBound) {
        String value;
        if (lowerBound != null) {
            value = lowerBound.withZoneSameInstant(ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern(QUERY_STRING_DATE_TIME_FORMAT));
            this.addQueryParam(name + ">", value);
        }
        if (upperBound != null) {
            value = upperBound.withZoneSameInstant(ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern(QUERY_STRING_DATE_TIME_FORMAT));
            this.addQueryParam(name + "<", value);
        }
    }

    public void addQueryParam(String name, String value) {
        this.addParam(this.queryParams, name, value);
    }

    public void addPostParam(String name, String value) {
        this.addParam(this.postParams, name, value);
    }

    public void addHeaderParam(String name, String value) {
        this.addParam(this.headerParams, name, value);
    }

    private void addParam(Map<String, List<String>> params, String name, String value) {
        if (value == null || value.equals("null")) {
            return;
        }
        if (!params.containsKey(name)) {
            params.put(name, new ArrayList());
        }
        params.get(name).add(value);
    }

    public String encodeFormBody() {
        return Request.encodeParameters(this.postParams);
    }

    public String encodeQueryParams() {
        return Request.encodeParameters(this.queryParams);
    }

    private static String encodeParameters(Map<String, List<String>> params) {
        ArrayList<String> parameters = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            try {
                String encodedName = URLEncoder.encode(entry.getKey(), "UTF-8");
                for (String value : entry.getValue()) {
                    if (value == null) continue;
                    String encodedValue = URLEncoder.encode(value, "UTF-8");
                    parameters.add(encodedName + "=" + encodedValue);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidRequestException("Couldn't encode params", entry.getKey(), e);
            }
        }
        return Request.joinIgnoreNull("&", parameters);
    }

    private static String joinIgnoreNull(String separator, String ... items) {
        return Request.joinIgnoreNull(separator, Arrays.asList(items));
    }

    private static String joinIgnoreNull(String separator, List<String> items) {
        StringBuilder builder = new StringBuilder();
        for (String item : items) {
            if (item == null) continue;
            if (builder.length() > 0) {
                builder.append(separator);
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public Map<String, List<String>> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, List<String>> getPostParams() {
        return this.postParams;
    }

    public Map<String, List<String>> getHeaderParams() {
        return this.headerParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request other = (Request)o;
        return Objects.equals((Object)this.method, (Object)other.method) && Objects.equals(this.buildURL(), other.buildURL()) && Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && Objects.equals(this.queryParams, other.queryParams) && Objects.equals(this.postParams, other.postParams) && Objects.equals(this.headerParams, other.headerParams);
    }
}

